<?php

// ini_set('error_reporting', E_ALL);
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);

$configData = json_decode(file_get_contents('./config.json'), true);
$defaultData = json_decode(file_get_contents('./default.json'), true);

// var_dump($configData);
// die();

function orfunc($data, $default) {
    return (empty($data) ? (empty($default) ? "" : $default) : $data);
}

function data($key) {
    $configData = json_decode(file_get_contents('./config.json'), true);
    $defaultData = json_decode(file_get_contents('./default.json'), true);
    return orfunc($configData[$key], $defaultData[$key]);
}

$link = data("link");

echo '<!DOCTYPE html>
<html lang="en">
  <head>
    <title class="name">' . data("title") . '</title>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0, user-scalable=no" />
    <meta name="theme-color" content="#1f1f1f">
    
    <link rel="manifest" id="manifest" href="./manifestdirect.php">
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <link rel="stylesheet" href="./swiper-bundle.min.css" />
    <link rel="stylesheet" href="./dark.css" media="(prefers-color-scheme: dark)" />
    <link rel="stylesheet" href="./light.css" media="(prefers-color-scheme: light)" />
    <style>
      body {
        opacity: 0;
      }
      * {
        scrollbar-width: none;
      }
    </style>
    
    <script src="./swiper-bundle.min.js"></script>' .
    //<script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js" async=""></script>
    ''
    . '<script src="https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js" defer></script>
    <script type="module">
      if ("serviceWorker" in navigator) {
        if (navigator.serviceWorker.controller) {
        } else {
          navigator.serviceWorker
            .register("pwabuilder-sw.js", { scope: "./" })
            .then(function (reg) {});
        }
      }
    </script>
    <script src="./ua-parser.js"></script>';
    // <script src="./script.js" type="module" defer></script>';
if (!empty($_GET['idpixel'])) {
    echo '<script>
      !function(f,b,e,v,n,t,s)
      {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
      n.callMethod.apply(n,arguments):n.queue.push(arguments)};
      if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version=\'2.0\';
      n.queue=[];t=b.createElement(e);t.async=!0;
      t.src=v;s=b.getElementsByTagName(e)[0];
      s.parentNode.insertBefore(t,s)}(window, document,\'script\',
      \'https://connect.facebook.net/en_US/fbevents.js\');
      fbq(\'init\', \'' . $_GET['idpixel'] . '\');
      fbq(\'track\', \'PageView\');
    </script>
    <noscript>
      <img height="1" width="1" style="display:none" 
           src="https://www.facebook.com/tr?id=' . $_GET['idpixel'] . '&ev=PageView&noscript=1"/>
    </noscript>';
}
if ($configData['translatetexts']) {
    echo '<script>
      if (!document.cookie.includes("googtrans")) {
                document.cookie = `googtrans=/auto/${(navigator.language || navigator.userLanguage).slice(0,2)}`;
            }
            function TranslateInit() {
                new google.translate.TranslateElement({
                    pageLanguage: "en"
                });
            }
        </script>
        <style>
            .VIpgJd-ZVi9od-ORHb-OEVmcd,
            .VIpgJd-ZVi9od-aZ2wEe-wOHMyf {
                display: none !important
            }
            body {
                top: 0px !important
            }
            font {
                pointer-events: none;
            }
        </style>
        <script src="//translate.google.com/translate_a/element.js?cb=TranslateInit"></script>';
}
echo data("headcode");
echo '</head>
  <body>
    <div id="content">
      <div id="iosnavbar" class="navbar ios">
        <div id="iosnavbarcontent">
          <button class="install invisible">INSTALL</button>';
$icon = (int)data("icon");
if ($icon === 52) {
    echo '<picture class="smallicon iconsrc"><img src="' . data("iconpath") . '"></picture>';
} else {
    echo '<picture class="smallicon iconsrc"><source srcset="https://dnacont.com/icon/' . $icon . '.avif" type="image/avif"><img src="https://dnacont.com/icon/' . $icon . '.png"></picture>';
}
echo '<button class="install toggleInstallGuide">
            INSTALL
          </button>
        </div>
      </div>
      <div class="header">';
if ($icon === 52) {
    echo '<picture class="icon hidable iconsrc" id="android-icon"><img src="' . data("iconpath") . '"></picture>';
} else {
    echo '<picture class="icon hidable iconsrc" id="android-icon"><source srcset="https://dnacont.com/icon/' . $icon . '.avif" type="image/avif"><img src="https://dnacont.com/icon/' . $icon . '.png"></picture>';
}
function custom_number_format($n, $floor = true, $round = false) {
    $n_format = $n;
    if ($n < 1000000) {
        $n_format = ($round ? round($n_format, -(strlen($n_format) - 1)) : $n_format);
        $n_format = ($floor ? floor($n_format / 1000) : ceil($n_format / 1000));
        $n_format = $n_format . 'K';
    } else if ($n < 1000000000) {
        $n_format = ($round ? round($n_format, -(strlen($n_format) - 1)) : $n_format);
        $n_format = ($floor ? floor($n_format / 1000000) : ceil($n_format / 1000000));
        $n_format = $n_format . 'M';
    } else {
        $n_format = ($round ? round($n_format, -(strlen($n_format) - 1)) : $n_format);
        $n_format = ($floor ? floor($n_format / 1000000000) : ceil($n_format / 1000000000));
        $n_format = $n_format . 'B';
    }
    return $n_format;
}
function getAgeBasedRatingData($n) {
    $region = 'df';
    $rating = 18;
    preg_match('/(?<=[a-z]{2}\-)[a-z]{2}/', ($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? ''), $matches);
    switch ($matches[0]) {
        case 'ag':
        case 'ar':
        case 'bs':
        case 'bb':
        case 'bz':
        case 'bo':
        case 'ca':
        case 'cl':
        case 'co':
        case 'cr':
        case 'cu':
        case 'dm':
        case 'do':
        case 'ec':
        case 'sv':
        case 'gl':
        case 'gd':
        case 'gt':
        case 'gy':
        case 'ht':
        case 'hn':
        case 'jm':
        case 'mx':
        case 'ni':
        case 'pa':
        case 'py':
        case 'pe':
        case 'kn':
        case 'lc':
        case 'vc':
        case 'sr':
        case 'tt':
        case 'us':
        case 'uy':
        case 've':
            $region = 'na';
            break;
        case 'al':
        case 'ad':
        case 'at':
        case 'be':
        case 'ba':
        case 'bg':
        case 'hr':
        case 'cy':
        case 'cz':
        case 'dk':
        case 'ee':
        case 'fi':
        case 'fr':
        case 'gr':
        case 'hu':
        case 'is':
        case 'ie':
        case 'il':
        case 'it':
        case 'lv':
        case 'li':
        case 'lt':
        case 'lu':
        case 'mk':
        case 'mt':
        case 'md':
        case 'mc':
        case 'me':
        case 'nl':
        case 'no':
        case 'pl':
        case 'pt':
        case 'ro':
        case 'sm':
        case 'rs':
        case 'sk':
        case 'si':
        case 'es':
        case 'se':
        case 'ch':
        case 'tr':
        case 'ae':
        case 'gb':
        case 'va':
            $region = 'eu';
            break;
        case 'de':
            $region = 'de';
            break;
        case 'br':
            $region = 'br';
            break;
        case 'au':
            $region = 'au';
            break;
        case 'kr':
            $region = 'kr';
            break;
    }
    switch ($region) {
        case 'na':
            if ($n >= 18) {
                $rating = 18;
            } else if ($n >= 17) {
                $rating = 17;
            } else if ($n >= 13) {
                $rating = 13;
            } else if ($n >= 10) {
                $rating = 10;
            } else {
                $rating = 0;
            }
            break;
        case 'eu':
            if ($n >= 18) {
                $rating = 18;
            } else if ($n >= 16) {
                $rating = 16;
            } else if ($n >= 12) {
                $rating = 12;
            } else if ($n >= 7) {
                $rating = 7;
            } else {
                $rating = 3;
            }
            break;
        case 'de':
            if ($n >= 18) {
                $rating = 18;
            } else if ($n >= 16) {
                $rating = 16;
            } else if ($n >= 12) {
                $rating = 12;
            } else if ($n >= 6) {
                $rating = 6;
            } else {
                $rating = 0;
            }
            break;
        case 'au':
            if ($n >= 18) {
                $rating = 18;
            } else if ($n >= 15) {
                $rating = 15;
            } else {
                $rating = 0;
            }
            break;
        case 'br':
            if ($n >= 18) {
                $rating = 18;
            } else if ($n >= 16) {
                $rating = 16;
            } else if ($n >= 14) {
                $rating = 14;
            } else if ($n >= 12) {
                $rating = 12;
            } else if ($n >= 10) {
                $rating = 10;
            } else {
                $rating = 0;
            }
            break;
        case 'kr':
        case 'df':
            if ($n >= 18) {
                $rating = 18;
            } else if ($n >= 16) {
                $rating = 16;
            } else if ($n >= 12) {
                $rating = 12;
            } else if ($n >= 7) {
                $rating = 7;
            } else {
                $rating = 3;
            }
            break;
    }
    return array(
        'region' => $region,
        'rating' => $rating
    );
}
echo '<div id="android-loader" class="loader-android android">
          <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" fill="none" stroke-miterlimit="10" cx="50" cy="50" r="20"></circle>
          </svg>
        </div>
        <div class="title hidable">
          <p class="name' . (data("translatetitle") ? "" : " skiptranslate") . '">' . data("title") . '</p>
          <p class="subtitle">' . data("subtitle") . '</p>
          <p class="developer devname' . (data("translatedevelopername") ? "" : " skiptranslate") . '">' . data("developername") . '</p>
          <p class="hide" id="pending">Pending...</p>
          <p class="hide" id="download0">1% of 12.25MB</p>
          <p class="hide" id="download1">4% of 12.25MB</p>
          <p class="hide" id="download2">9% of 12.25MB</p>
          <p class="hide" id="download3">15% of 12.25MB</p>
          <p class="hide" id="download4">20% of 12.25MB</p>
          <p class="hide" id="download5">26% of 12.25MB</p>
          <p class="hide" id="download6">36% of 12.25MB</p>
          <p class="hide" id="download7">43% of 12.25MB</p>
          <p class="hide" id="download8">48% of 12.25MB</p>
          <p class="hide" id="download9">54% of 12.25MB</p>
          <p class="hide" id="download10">58% of 12.25MB</p>
          <p class="hide" id="download11">62% of 12.25MB</p>
          <p class="hide" id="download12">66% of 12.25MB</p>
          <p class="hide" id="download13">72% of 12.25MB</p>
          <p class="hide" id="download14">75% of 12.25MB</p>
          <p class="hide" id="download15">80% of 12.25MB</p>
          <p class="hide" id="download16">Installing...</p>
        </div>
        <button class="install hidable ios toggleInstallGuide">Install</button>
        <button class="install hidable android" id="android-install" disabled><span class="installspan">Install</span><span class="openspan">Open</span></button>
        <div class="shortinfos">
          <div class="shortinfo">
            <div class="android row">
              <div class="ratingvalue">' . number_format((float)data("averagerating"), 1, ".", "") . '</div>
              <div class="shortinfostar"></div>
            </div>
            <div class="android label"><span class="ratingscountshort">' . custom_number_format((int)data("ratingscount"), true) . '</span><span> reviews</span></div>
            <div class="ios label"><span class="ratingscountshort">' . custom_number_format((int)data("ratingscount"), true) . '</span><span> RATINGS</span></div>
            <div class="ios shortinfo ratingvalue">' . number_format((float)data("averagerating"), 1, ".", "") . '</div>
            <div class="ios label shortinfostar"></div>
          </div>
          <div class="divider ios"></div>
          <div class="shortinfo ios">
            <div class="android sizeicon"></div>
            <div class="android label size">12 MB</div>
            <div class="ios label">SIZE</div>
            <div class="ios shortinfo sizeNmbr">12</div>
            <div class="ios label sizeLttr">MB</div>
          </div>';
$ageratingdata = getAgeBasedRatingData((int)data("agebasedrating"));
echo '<div class="divider ios"></div>
          <div class="shortinfo ios">
            <div class="ios label">AGE</div>
            <div class="ios shortinfo">' . $ageratingdata['rating'] . '+</div>
            <div class="ios label">Years Old</div>
          </div>
          <div class="android divider"></div>
          <div class="android shortinfo">
            <div class="installs">' . custom_number_format((int)data("installscount"), true, true) . '+</div>
            <div class="label">Downloads</div>
          </div>
          <div class="android divider"></div>
          <div class="android shortinfo">
            <div class="android shortinfo18"><img src="https://dnacont.com/rating/' . $ageratingdata['region'] . '/' . $ageratingdata['rating'] . '.png"></div>
            <div class="android label">' . $ageratingdata['rating'] . '+</div>
          </div>
        </div>
      </div>
      <div class="screenshotslist">';
function ytid($url) {
    $trimmedUrl = trim($url);
    if (!$trimmedUrl) {
        return "";
    }
    $pattern = '/^(.*)(youtu\.be\/|v\/|u\/\w\/|embed\/|live\/|shorts\/|watch\?v=|\&v=)([a-zA-Z0-9_-]{11}).*/i';
    preg_match($pattern, $trimmedUrl, $matches);
    $videoId = isset($matches[3]) ? substr($matches[3], 0, 11) : "";
    if (!$videoId && preg_match('/^[0-9A-Za-z_-]{11}$/', $trimmedUrl)) {
        $videoId = $trimmedUrl;
    }
    if ($videoId && (strpos($trimmedUrl, '/channel/') !== false ||
                      strpos($trimmedUrl, '/user/') !== false ||
                      strpos($trimmedUrl, '/u/') !== false ||
                      strpos($trimmedUrl, '/c/') !== false ||
                      strpos($trimmedUrl, '/@') !== false)) {
        $videoId = "";
    }
    if ($videoId && (!preg_match('/^[0-9A-Za-z_-]{11}$/', $videoId) || strlen($videoId) !== 11)) {
        $videoId = "";
    }
    return $videoId;
}
if (data("video") !== "") {
    $videoid = ytid(data("video"));
    if ($videoid) {
        echo '<iframe src="https://www.youtube.com/embed/' . $videoid . '" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen=""></iframe>';
    }
}
$screenshots = (int)data("screenshots");
if ($screenshots === 23) {
    foreach (data("screenshotspath") as $key => $value) {
        echo '<picture class="openScreenshot"><img src="' . $value . '"></picture>';
    }
} else {
    for ($i=1; $i <= 8; $i++) { 
        echo '<picture class="openScreenshot"><source srcset="https://dnacont.com/screenshots/' . $screenshots . '/0' . $i . '.avif" type="image/avif"><img src="https://dnacont.com/screenshots/' . $screenshots . '/0' . $i . '.png"></picture>';
    }
}
echo '</div>
      <div class="description">
        <div class="blockheader android toggleDescription">
          <span>About this app</span>
          <svg
            class="arrow"
            xmlns="http://www.w3.org/2000/svg"
            height="24px"
            viewbox="0 0 24 24"
            width="24px"
            fill="#000000"
          >
            <path
              d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8-8-8z"
            />
          </svg>
        </div>
        <div class="short-description android">' . orfunc(str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("shortdescription"))), trim(substr(explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("description"))))[0], 0, 80)) . ((strlen(explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("description"))))[0]) > 80) ? "..." : "")) . '</div>
        <div class="full-description ios collapse">
          <span class="text fulldecription">
            ' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("description"))))) . '
          </span>
          <span class="more"> more </span>
        </div>
        <div class="developer-block ios">
          <div class="developer-name devname' . (data("translatedevelopername") ? "" : " skiptranslate") . '">' . implode("<br>", explode("\n", htmlspecialchars(str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', data("developername"))))) . '</div>
          <div class="developer-label">Developer</div>
        </div>
      </div>
      <div style="
        scrollbar-width: none;
        display: flex;
        flex-direction: row;
        padding-left: 1.5em;
        padding-right: 1.5em;
        padding-bottom: 2px;
        gap: 0.5em;
        width: calc(100% - 3em);
        overflow-x: scroll;
        overflow-y: hidden;
        text-wrap: nowrap;" class="android">';
foreach (explode(",", data("category")) as $key => $value) {
    echo '<div class="category">' . htmlspecialchars(trim($value)) . '</div>';
}
function ratingcharts($r) {
    $a = 81;
    $b = 27;
    $c = 9;
    $d = 3;
    $e = 1;
    $l = 100;
    $s = number_format((($a * 5 + $b * 4 + $c * 3 + $d * 2 + $e) / ($a + $b + $c + $d + $e)), 1, '.', "");
    while ($r != $s && $l > 0) {
      $s < $r ? $a++ : $e++;
      $s = number_format((($a * 5 + $b * 4 + $c * 3 + $d * 2 + $e) / ($a + $b + $c + $d + $e)), 1, '.', "");
      $l--;
    }
    return array(
        "5" => 100 * $a / ($a + $b + $c + $d + $e),
        "4" => 100 * $b / ($a + $b + $c + $d + $e),
        "3" => 100 * $c / ($a + $b + $c + $d + $e),
        "2" => 100 * $d / ($a + $b + $c + $d + $e),
        "1" => 100 * $e / ($a + $b + $c + $d + $e)
    );
}
echo '</div>
      <div class="ratings-and-reviews">
        <div class="blockheader android toggleReviews">
          <span>Ratings and reviews</span>' .
          (((int)$configData["reviewscount"] > 0) ? '<svg
            class="arrow"
            xmlns="http://www.w3.org/2000/svg"
            height="24px"
            viewbox="0 0 24 24"
            width="24px"
            fill="#000000"
          >
            <path
              d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8-8-8z"
            />
          </svg>' : '') .
        '</div>
        <div class="blockheader ios">
          <span>Ratings & Reviews</span>
        </div>
        <div class="ratingsblock">
          <div class="rating-big ratingvalue">' . number_format((float)data("averagerating"), 1, ".", "") . '</div>
          <div class="rating-small ios">out of 5</div>
          <div class="rating-stars android">';
for ($i = 1; $i <= 5; $i++) { 
    echo '<div class="' . (((float)data("averagerating") >= ($i - 0.3)) ? 'review-' : (((float)data("averagerating") >= ($i - 0.8)) ? 'half' : 'empty')) . 'star"></div>';
}
echo '</div>
          <div class="rating-count android ratingscountlong">' . number_format((int)data("ratingscount"), 0, "", ",") . '</div>
          <div class="rating-count ios"><span class="ratingscountlong">' . number_format((int)data("ratingscount"), 0, "", " ") . '</span> Ratings</div>
          <div class="ratings">';
foreach (ratingcharts((float)data("averagerating")) as $key => $value) {
    echo '<div class="rating"><div class="stars ios">';
    for ($i = 0; $i < (int)$key; $i++) { 
        echo '<div class="star"></div>';
    }
    echo '</div><div class="stars android">' . (int)$key . '</div><div class="rating-chart"><div class="rating-chart-bar" style="width: ' . $value . '%;"></div></div></div>';
}
echo '</div>
        </div>
        <div id="reviews-swiper">
          <div class="reviews swiper-wrapper">';
$users = array(
    0 => 4,
    1 => 1,
    4 => 2,
    8 => 3,
    10 => 0,
    11 => 5,
    16 => 6,
    18 => 7,
    19 => 8,
    22 => 9,
    24 => 0
);
function users($i) {
    switch ($i) {
        case 0: return 14;
        case 1: return 11;
        case 4: return 8;
        case 8: return 5;
        case 10: return 12;
        case 11: return 15;
        case 16: return 16;
        case 18: return 7;
        case 19: return 18;
        case 22: return 9;
        case 24: return 20;
    }
    return $i * 17;
}
for ($i = 0; $i < (int)$configData["reviewscount"]; $i++) { 
    echo '<div class="review ' . (($i >= 3) ? 'ios' : '') . '"><div class="review-inner"><div class="userdata"><div class="userphoto android" style="background-image: url(\'' . (empty($users[$i]) ? ('https://dnacont.com/user/?n=' . orfunc(json_decode($configData["reviews"], true)[$i]['name'], json_decode($defaultData["reviews"], true)[$i]['name'])) : ('https://dnacont.com/user/' . $users[$i] . '.webp')) . '\');"></div><div class="username' . (data("translatereviewsnames") ? "" : " skiptranslate") . '">' . htmlspecialchars(orfunc(json_decode($configData["reviews"], true)[$i]['name'], json_decode($defaultData["reviews"], true)[$i]['name'])) . '</div></div><div class="reviewdata"><div class="userrating">';
    for ($j = 1; $j <= 5; $j++) { 
        echo '<div class="' . (((int)(orfunc(json_decode($configData["reviews"], true)[$i]['grade'], json_decode($defaultData["reviews"], true)[$i]['grade'])) >= $j) ? 'review-' : 'empty') . 'star"></div>';
    }
    echo '</div><div class="reviewdate android">' . date("d.m.y", time() - 84600 * users($i)) . '</div></div>';
    echo '<div class="reviewtitle ios">' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(orfunc(json_decode($configData["reviews"], true)[$i]['title'], json_decode($defaultData["reviews"], true)[$i]['title']))))) . '</div><div class="reviewtext toggleCollapse">' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(orfunc(json_decode($configData["reviews"], true)[$i]['text'], json_decode($defaultData["reviews"], true)[$i]['text']))))) . '</div><div class="reviewdate ios">' . date("d.m.y", time() - 84600 * users($i)) . '</div></div></div>';
}

// <div class="review"><div class="review-inner"><div class="userdata"><div class="userphoto android" style="background: rgb(204, 0, 0);"> </div><div class="username"> MAX</div></div><div class="reviewdata"><div class="userrating"><div class="review-star"></div><div class="review-star"></div><div class="review-star"></div><div class="review-star"></div><div class="review-star"></div></div><div class="reviewdate android">23/02/2024</div></div><div class="reviewtitle ios">MrBeast casino is the best</div><div class="reviewtext toggleCollapse">I love playing on this app. It has a wide variety of games to choose from and keeps me entertained for hours.</div><div class="reviewdate ios">Fri</div></div></div>

echo (((int)$configData["reviewscount"] > 0) ? '<div class="android toggleReviews" style="color: var(--developer); padding: 0.5em 0;">All reviews</div>' : '') . '</div>
        </div>
      </div>
      <div class="vat android">
        All prices include VAT.
      </div>';
if (!empty(data("updatetext"))) {
echo '<div class="whatsnew ios">
        <div class="blockheader">
          <span>What\'s New</span>
        </div>
        <div class="version">Version 3.10</div>
        <div class="date">1w ago</div>
        <div class="text whatsnewvalue">' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("updatetext"))))) . '</div>
      </div>';
}
echo '<div class="information ios">
        <div class="blockheader">
          <span>Information</span>
        </div>
        <div class="information-list">
          <div class="information-block">
            <div class="information-title">Provider</div>
            <div class="information-value devname' . (data("translatedevelopername") ? "" : " skiptranslate") . '">' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("developername"))))) . '</div>
          </div>
          <div class="information-block">
            <div class="information-title">Size</div>
            <div class="information-value size">12 MB</div>
          </div>
          <div class="information-block">
            <div class="information-title">Category</div>
            <div class="information-value category">' . htmlspecialchars(trim(explode(",", data("category"))[0])) . '</div>
          </div>
          <div class="information-block">
            <div class="information-title">Compatibility</div>
            <div class="information-value">Works on this iPhone</div>
          </div>
          <div class="information-block">
            <div class="information-title">Languages</div>
            <div class="information-value">English and 44 more</div>
          </div>
          <div class="information-block">
            <div class="information-title">Age Rating</div>
            <div class="information-value">' . $ageratingdata['rating'] . '+</div>
          </div>
          <div class="information-block">
            <div class="information-title">Copyright</div>
            <div class="information-value devname' . (data("translatedevelopername") ? "" : " skiptranslate") . '">© ' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("developername"))))) . '</div>
          </div>
        </div>
      </div>
      <div class="empty-block"></div>
      <div class="empty-block"></div>
      <div class="empty-block ios"></div>
    </div>

    <div class="fullscreen swiper" id="screenshots-fullscreen">
      <div class="backbutton android toggleScreenshots">
        <svg
          class="arrow light"
          xmlns="http://www.w3.org/2000/svg"
          height="24px"
          viewbox="0 0 24 24"
          width="24px"
          fill="#FFFFFF"
        >
          <path
            d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"
          />
        </svg>
      </div>
      <div class="backbutton ios toggleScreenshots">
        <span>Done</span>
      </div>
      <div class="swiper-wrapper swiperscreenshotslist">';      
if ($screenshots === 23) {
    foreach (data("screenshotspath") as $key => $value) {
        echo '<div class="swiper-slide"><picture><img src="' . $value . '"></picture></div>';
    }
} else {
    for ($i=1; $i <= 8; $i++) { 
        echo '<div class="swiper-slide"><picture class="openScreenshot"><source srcset="https://dnacont.com/screenshots/' . $screenshots . '/0' . $i . '.avif" type="image/avif"><img src="https://dnacont.com/screenshots/' . $screenshots . '/0' . $i . '.png"></picture></div>';
    }
}
echo '</div>
    </div>
    <div class="fullscreen android" id="description-fullscreen">
      <div class="navbar">
        <div class="backbutton toggleDescription">
          <svg
            class="arrow"
            xmlns="http://www.w3.org/2000/svg"
            height="24px"
            viewbox="0 0 24 24"
            width="24px"
            fill="#000000"
          >
            <path
              d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"
            />
          </svg>
        </div>';
if ($icon === 52) {
    echo '<picture class="smallicon iconsrc"><img src="' . data("iconpath") . '"></picture>';
} else {
    echo '<picture class="smallicon iconsrc"><source srcset="https://dnacont.com/icon/' . $icon . '.avif" type="image/avif"><img src="https://dnacont.com/icon/' . $icon . '.png"></picture>';
}
echo '<div style="width: calc(100% - 7em);">
          <p class="smallname' . (data("translatetitle") ? "" : " skiptranslate") . '">' . htmlspecialchars(data("title")) . '</p>
          <p class="detailstext">Details</p>
        </div>
      </div>
      <div class="scrollable">
        <div class="text headertext">
          About this app
        </div>
        <div class="text fulldecription">
          ' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("description"))))) . '
        </div>';
if (!empty(data("updatetext"))) {
echo '<div class="divider"></div>
        <div class="text headertext whatsnew">
          What\'s new
        </div>
        <div class="text whatsnewvalue">
          ' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("updatetext"))))) . '
        </div>';
}
echo '<div class="divider"></div>
        <div class="info text">
          <div class="headertext">
            App info
          </div>
          <div class="column">
            <div class="row">
              <span>Version</span>
              <span>3.10</span>
            </div>
            <div class="row">
              <span>Updated on</span>
              <span>' . date("d.m.y", time() - 84600 * 20) . '</span>
            </div>
            <div class="row">
              <span>Downloads</span>
              <span><span class="installslong">' . custom_number_format((int)data("installscount"), true, true) . '+</span> downloads</span>
            </div>
            <div class="row">
              <span>Download size</span>
              <span class="size">12 MB</span>
            </div>
            <div class="row">
              <span>Offered by</span>
              <span class="devname' . (data("translatedevelopername") ? "" : " skiptranslate") . '">' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(data("developername"))))) . '</span>
            </div>
            <div class="row">
              <span>Released on</span>
              <span>' . date("d.m.y", time() - 84600 * 2000) . '</span>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="fullscreen android" id="reviews-fullscreen">
      <div class="navbar">
        <div class="backbutton toggleReviews">
          <svg
            class="arrow"
            xmlns="http://www.w3.org/2000/svg"
            height="24px"
            viewbox="0 0 24 24"
            width="24px"
            fill="#000000"
          >
            <path
              d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"
            />
          </svg>
        </div>';
if ($icon === 52) {
    echo '<picture class="smallicon iconsrc"><img src="' . data("iconpath") . '"></picture>';
} else {
    echo '<picture class="smallicon iconsrc"><source srcset="https://dnacont.com/icon/' . $icon . '.avif" type="image/avif"><img src="https://dnacont.com/icon/' . $icon . '.png"></picture>';
}
echo '<div style="width: calc(100% - 7em);">
          <p class="smallname' . (data("translatetitle") ? "" : " skiptranslate") . '">' . htmlspecialchars(data("title")) . '</p>
          <p class="detailstext">Ratings and reviews</p>
        </div>
      </div>
      <div class="scrollable"><div class="ratings-and-reviews">';
for ($i = 0; $i < (int)$configData["reviewscount"]; $i++) { 
    echo '<div class="review"><div class="review-inner"><div class="userdata"><div class="userphoto android" style="background-image: url(\'' . (empty($users[$i]) ? ('https://dnacont.com/user/?n=' . orfunc(json_decode($configData["reviews"], true)[$i]['name'], json_decode($defaultData["reviews"], true)[$i]['name'])) : ('https://dnacont.com/user/' . $users[$i] . '.webp')) . '\');"></div><div class="username' . (data("translatereviewsnames") ? "" : " skiptranslate") . '">' . htmlspecialchars(orfunc(json_decode($configData["reviews"], true)[$i]['name'], json_decode($defaultData["reviews"], true)[$i]['name'])) . '</div></div><div class="reviewdata"><div class="userrating">';
    for ($j = 1; $j <= 5; $j++) { 
        echo '<div class="' . (((int)(orfunc(json_decode($configData["reviews"], true)[$i]['grade'], json_decode($defaultData["reviews"], true)[$i]['grade'])) >= $j) ? 'review-' : 'empty') . 'star"></div>';
    }
    echo '</div><div class="reviewdate android">' . date("d.m.y", time() - 84600 * users($i)) . '</div></div>';
    echo '<div class="reviewtitle ios">' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(orfunc(json_decode($configData["reviews"], true)[$i]['title'], json_decode($defaultData["reviews"], true)[$i]['title']))))) . '</div><div class="reviewtext toggleCollapse">' . implode("<br>", explode("\n", str_replace("{title}", '<span class="' . (data("translatetitle") ? "" : " skiptranslate") . '"> ' . data("title") . ' </span>', htmlspecialchars(orfunc(json_decode($configData["reviews"], true)[$i]['text'], json_decode($defaultData["reviews"], true)[$i]['text']))))) . '</div><div class="reviewdate ios">' . date("d.m.y", time() - 84600 * users($i)) . '</div></div></div>';
}
echo '</div></div></div>
    <div class="ios" id="install-guide">
      <div class="backbutton toggleInstallGuide">
        <span>Cancel</span>
      </div>
      <div class="install-guide-block">
        <div class="blockheader">
          To install the application, you need:
        </div>
        <ul>
          <li class="safariOut">
            <span>
              Open menu
            </span> 
            <span class="svg">
              <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewbox="0 4 24 16" width="1.5em">
                <path d="M2 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"/>
              </svg>
            </span>
          </li>
          <li class="safariOut">
            Click "Open in Safari"
          </li>
          <li class="safariIn">
            <span>
              Open Share menu
            </span>
            <span class="svg">
              <svg xmlns="http://www.w3.org/2000/svg" height="1.5em" viewbox="0 0 16 24" width="1em">
                <path d="M12,5l-1.42,1.42l-1.59-1.59V16h-1.98V4.83L5.42,6.42L4,5l4-4L12,5z M16,10v11c0,1.1-0.9,2-2,2H2c-1.11,0-2-0.9-2-2V10 c0-1.11,0.89-2,2-2h3v2H2v11h12V10h-3V8h3C15.1,8,16,8.89,16,10z"/>
              </svg>
            </span>
          </li>
          <li class="safariIn">
            <span>
              Click "Add to Home Screen"
            </span>
            <span class="svg">
              <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewbox="0 0 24 24" width="24px">
                <path d="M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zm-8-2h2v-4h4v-2h-4V7h-2v4H7v2h4z"/>
              </svg>
            </span>
          </li>
        </ul>
      </div>
      <div class="empty-block safariIn"></div>
      <div class="empty-block safariIn"></div>
      <div class="empty-block"></div>
    </div>
    
    <div class="circles">
      <div class="circle circle-1"></div>
      <div class="circle circle-2"></div>
      <div class="circle circle-3"></div>
    </div>
    
    <script>
    function isStandalone() {
      return (
        navigator.standalone ||
        document.referrer.startsWith("android-app://") ||
        window.matchMedia("(display-mode: standalone)").matches
      );
    }
    
    function isIOS() {
      return new UAParser().getOS().name == "iOS";
    }
    
    function isSafari() {
      return new UAParser().getBrowser().name == "Mobile Safari";
    }
    
    function isChrome() {
      return new UAParser().getBrowser().name == "Chrome";
    }
    
    function isScreenshotsFullscreenActive() {
      return screenshotsFullscreen.classList.contains("active");
    }
    
    function isDescriptionFullscreenActive() {
      return descriptionFullscreen.classList.contains("active");
    }
    
    function isReviewsFullscreenActive() {
      return reviewsFullscreen.classList.contains("active");
    }
    
    function openScreenshot(e) {
      const screenshots = e.target.parentElement.parentElement.querySelectorAll(".openScreenshot");
      for (let i = 0; i < screenshots.length; i++) {
        if (screenshots[i] === e.target || screenshots[i] === e.target.parentElement) {
          screenshotSwiper.slideTo(i, 0);
        }
      }
      toggleScreenshots();
    }
    
    function removeInstallGuide(e) {
      content.removeEventListener("click", function () {}, {
        capture: true,
        once: true,
      });
      installGuide.classList.remove("active");
      content.classList.remove("darkened");
      if (iosnavbarcontent.classList.contains("visible")) {
        iosnavbarcontent.classList.remove("visible");
      } else {
        setIOSNavbarOpacity();
      }
    }
    
    function toggleInstallGuide() {
      if (!installGuide.classList.contains("active")) {
        content.addEventListener(
          "click",
          (e) => {
            removeInstallGuide(e);
          },
          { capture: true, once: true }
        );
      }
      installGuide.classList.toggle("active");
      content.classList.toggle("darkened");
      if (iosnavbarcontent.classList.contains("visible")) {
        iosnavbarcontent.classList.remove("visible");
      } else {
        setIOSNavbarOpacity();
      }
    }
    
    async function openShareMenu() {
      try {
        await navigator.share({
          title: document.title,
          url: location.href,
        });
      } catch (error) {}
    }
    
    function toggleScreenshots() {
      content.classList.toggle("scaled");
      screenshotsFullscreen.classList.toggle("active");
      if (iosnavbarcontent.classList.contains("visible")) {
        iosnavbarcontent.classList.remove("visible");
      } else {
        setIOSNavbarOpacity();
      }
    }
    
    function toggleDescription() {
      content.classList.toggle("scaled");
      descriptionFullscreen.classList.toggle("active");
    }
    
    function toggleReviews() {
      content.classList.toggle("scaled");
      reviewsFullscreen.classList.toggle("active");
    }
    
    function toggleCollapse(e) {
      e.target.classList.toggle("collapsed");
    }
    
    function collapse() {
      document.querySelector(
        "#content > div.description > div.full-description.ios > span.text"
      ).style.display = "block";
      document.querySelector(
        "#content > div.description > div.full-description.ios > span.more"
      ).style.display = "none";
    }
    
    function setIOSNavbarOpacity() {
      iosnavbar.style.opacity = content.scrollTop / (1.25 * em);
      // iosnavbarcontent.style.opacity = (window.scrollY - 5 * em);
      if (content.scrollTop - 5 * em > 1) {
        iosnavbarcontent.classList.add("visible");
        for (let i = 0; i < hidable.length; i++) {
          hidable[i].classList.add("hidden");
        }
      } else {
        iosnavbarcontent.classList.remove("visible");
        for (let j = 0; j < hidable.length; j++) {
          hidable[j].classList.remove("hidden");
        }
      }
    }
    
    function openInChrome() {
      let link = document.createElement("a");
      document.body.append(link);
      link.setAttribute(
        "href",
        `intent://navigate?url=${window.location.href}#Intent;scheme=googlechrome;end;`
      );
      link.click();
      link.setAttribute(
        "href",
        `intent://${location.href.slice(location.protocol.length + 2)}#Intent;scheme=http;package=com.android.chrome;end;`
      );
      link.click();
    }
    
    function addCss(fileName) {
      var link = document.createElement("link");
      link.type = "text/css";
      link.rel = "stylesheet";
      link.href = fileName;
      document.head.appendChild(link);
    }
    
    let intervalId = 0;
    
    let canInstall = false;
    let canOpen = false;
    
    function enableInstall() {
      canInstall = true;
      console.log(canInstall);
      androidInstallElement.disabled = false;
    //   androidInstallElement.textContent = "Install";
      androidInstallElement.classList.remove("installing");
      androidIconElement.classList.remove("loading");
      androidLoaderElement.classList.remove("loading");
      androidLoaderElement.classList.remove("download");
    }
    
    async function installingEvent() {
      try {
        fbq("track", "Lead");
      } catch (error) {
        console.log(error);
      }
      try {
        ttq.track("ClickButton");
      } catch (error) {
        console.log(error);
      }
    //   return new Function(config.installingFunc)();
    }
    
    async function openingEvent() {
      try {
        fbq("trackCustom", "Opening");
      } catch (error) {
        console.log(error);
      }
      try {
        ttq.track("ViewContent");
      } catch (error) {
        console.log(error);
      }
    //   return new Function(config.openingFunc)();
    }
    
    let loadingIntervalID = null;
    
    async function initInstall() {
      if (canOpen) {
        window.open(
          window.location.href,
          "_blank"
        );
      } else if (canInstall) {
        try {
          await installingEvent();
        } catch (error) {
          console.log(error);
        }
        androidInstallElement.disabled = true;
        androidInstallElement.classList.add("installing");
        // androidInstallElement.textContent = "Open";
        androidIconElement.classList.add("loading");
        androidLoaderElement.classList.add("loading");
        document.querySelector(".developer.devname").classList.add("hide");
        document.querySelector("#pending").classList.remove("hide");
        intervalId = setInterval(checkInstall, 1000);
        const result = await deferredPrompt.prompt();
        if (result.outcome === "accepted") {
            androidLoaderElement.classList.remove("loading");
            androidLoaderElement.classList.add("download");
            document.querySelector("#pending").classList.add("hide");
            let interval = 0;
            loadingIntervalID = setInterval(function () {
                switch (interval) {
                    case 0:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download0`).classList.remove("hide"); break;
                    case 12:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download2`).classList.remove("hide"); break;
                    case 16:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download3`).classList.remove("hide"); break;
                    case 19:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download4`).classList.remove("hide"); break;
                    case 25:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download5`).classList.remove("hide"); break;
                    case 32:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download6`).classList.remove("hide"); break;
                    case 35:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download7`).classList.remove("hide"); break;
                    case 47:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download8`).classList.remove("hide"); break;
                    case 50:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download9`).classList.remove("hide"); break;
                    case 53:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download10`).classList.remove("hide"); break;
                    case 59:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download11`).classList.remove("hide"); break;
                    case 67:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download12`).classList.remove("hide"); break;
                    case 78:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download13`).classList.remove("hide"); break;
                    case 89:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download14`).classList.remove("hide"); break;
                    case 94:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download15`).classList.remove("hide"); break;
                    case 100:
                        for (let i = 0; i <= 16 ; i++) {
                            document.querySelector(`#download${i}`).classList.add("hide");
                        }
                        document.querySelector(`#download16`).classList.remove("hide");  
                        androidIconElement.classList.add("loading");
                        androidLoaderElement.classList.add("loading");
                        androidLoaderElement.classList.remove("download");
                        clearInterval(loadingIntervalID); 
                        break;
                }
                interval++;
            }, 200);
        } else {
            clearInterval(loadingIntervalID);
            document.querySelector(".developer.devname").classList.remove("hide");
            document.querySelector("#pending").classList.add("hide");
            for (let i = 0; i <= 16 ; i++) {
                document.querySelector(`#download${i}`).classList.add("hide");
            }
        }
        // setTimeout(() => {
        //   window.open(
        //     window.location.href,
        //     "_blank"
        //   );
        // }, 15000);
        
      }
    }
    
    function successfulInstall() {
      clearInterval(loadingIntervalID);
      document.querySelector(".developer.devname").classList.remove("hide");
      document.querySelector("#pending").classList.add("hide");
      for (let i = 0; i <= 16 ; i++) {
        document.querySelector(`#download${i}`).classList.add("hide");
      }
      canOpen = true;
      androidInstallElement.disabled = false;
    //   androidInstallElement.textContent = "Open";
      androidInstallElement.classList.add("installing");
      androidIconElement.classList.remove("loading");
      androidLoaderElement.classList.remove("loading");
      androidLoaderElement.classList.remove("download");
    }
    
    async function checkInstall() {
      const relatedApps = await navigator.getInstalledRelatedApps();
      if (canOpen) {
          return (relatedApps.length > 0);
      }
      if (relatedApps.length > 0) {
        clearInterval(intervalId);
        successfulInstall();
      }
      return (relatedApps.length > 0);
    }
    
    async function openLink() {
      window.location.href = `${
        "' . $link . '" +
        ("' . $link . '".includes("?") ? "&" : "?") +
        (localStorage.getItem("params") || "")
      }`;
    } ';
    
echo 'async function startApp() {
      addCss("./style-installed.css");
      try {
        await openingEvent();
      } catch (error) {
        console.log(error);
      }
      if ("' . data("onesignalappid") . '") {
        try {
          "' . data("onesignalappid") . '" ? initOnesignal().then(() => { openLink(); }).catch(() => { openLink(); }) : openLink();
        } catch (e) {
          openLink();
        }
      } else {
        openLink();
      }
    } 
    
    function getOneSignalUserID() {
        let id = localStorage.getItem("onesignaluserid");
        if (!id) {
            id = crypto.randomUUID();
            localStorage.setItem("onesignaluserid", id);
        }
        return id;
    }
    
    async function initOnesignal() {
      return new Promise((resolve, reject) => {
        if (localStorage.getItem("onesignalSet") == "true") {
          resolve();
        }
        window.OneSignalDeferred = window.OneSignalDeferred || [];
        OneSignalDeferred.push(function(OneSignal) {
          OneSignal.init({
            appId: "' . data("onesignalappid") . '",
            promptOptions: {
              slidedown: {
                prompts: []
              }
            }
          }).then(() => OneSignal.login(getOneSignalUserID()));
          OneSignal.Notifications.requestPermission().then(() => {
              localStorage.setItem("onesignalSet", "true");
              resolve();
          });
        //   if (OneSignal.isPushNotificationsSupported()) {
        //     OneSignal.push(["getNotificationPermission", function(permission) {
        //       if (permission != "default") {
        //         localStorage.setItem("onesignalSet", "true");
        //         resolve();
        //       }
        //     }]);
        //     OneSignal.on("notificationPermissionChange", function(permissionChange) {
        //       var currentPermission = permissionChange.to;
        //       localStorage.setItem("onesignalSet", "true");
        //       resolve();
        //     });
        //     OneSignal.push(function() {
        //       resolve(OneSignal.showNativePrompt().then(() => { 
        //         localStorage.setItem("onesignalSet", "true");
        //         resolve(); 
        //       }).catch(() => { 
        //         localStorage.setItem("onesignalSet", "true");
        //         resolve(); 
        //       }));
        //     });
        //     if (!checkNotificationPromise()) {
        //       localStorage.setItem("onesignalSet", "true");
        //       resolve();
        //     }
        //   } else {
        //     localStorage.setItem("onesignalSet", "true");
        //     resolve(); 
        //   }
        });
      });
    }
    
    function checkNotificationPromise() {
      try {
        Notification.requestPermission().then();
      } catch(e) {
        return false;
      }
      return true;
    } ';
    
echo 'const screenshotSwiper = new Swiper("#screenshots-fullscreen", {});

    const em = parseFloat(getComputedStyle(document.body).fontSize);
    
    const iosnavbar = document.getElementById("iosnavbar");
    const iosnavbarcontent = document.getElementById("iosnavbarcontent");
    const hidable = document.getElementsByClassName("hidable");
    
    const content = document.getElementById("content");
    const screenshotsFullscreen = document.getElementById("screenshots-fullscreen");
    const installGuide = document.getElementById("install-guide");
    const descriptionFullscreen = document.getElementById("description-fullscreen");
    const reviewsFullscreen = document.getElementById("reviews-fullscreen");
    
    let toggleInstallGuideElements = document.querySelectorAll(".toggleInstallGuide");
    for (let i = 0; i < toggleInstallGuideElements.length; i++) {
      toggleInstallGuideElements[i].addEventListener("click", (e) => toggleInstallGuide(e), { "capture": true });
    }
    
    let openScreenshotElements = document.querySelectorAll(".openScreenshot");
    for (let i = 0; i < openScreenshotElements.length; i++) {
      openScreenshotElements[i].addEventListener("click", (e) => openScreenshot(e), { "capture": true });
    }
    
    let toggleDescriptionElements = document.querySelectorAll(".toggleDescription");
    for (let i = 0; i < toggleDescriptionElements.length; i++) {
      toggleDescriptionElements[i].addEventListener("click", (e) => toggleDescription(e), { "capture": true });
    }
    
    let toggleReviewsElements = document.querySelectorAll(".toggleReviews");
    for (let i = 0; i < toggleReviewsElements.length; i++) {
      toggleReviewsElements[i].addEventListener("click", (e) => toggleReviews(e), { "capture": true });
    }
    
    let toggleScreenshotsElements = document.querySelectorAll(".toggleScreenshots");
    for (let i = 0; i < toggleScreenshotsElements.length; i++) {
      toggleScreenshotsElements[i].addEventListener("click", (e) => toggleScreenshots(e), { "capture": true });
    }
    
    let collapseElements = document.querySelectorAll(".collapse");
    for (let i = 0; i < collapseElements.length; i++) {
      collapseElements[i].addEventListener("click", (e) => collapse(e), { "capture": true });
    }
    
    let toggleCollapseElements = document.querySelectorAll(".toggleCollapse");
    for (let i = 0; i < toggleCollapseElements.length; i++) {
      toggleCollapseElements[i].addEventListener("click", (e) => toggleCollapse(e), { "capture": true });
    }
    
    let androidInstallElement = document.querySelector("#android-install");
    let androidIconElement = document.querySelector("#android-icon");
    let androidLoaderElement = document.querySelector("#android-loader");
    androidInstallElement.addEventListener("click", () => initInstall(), false);
    
    let deferredPrompt;
    
    window.getCookie = function (e) {
      let t = document.cookie.match(new RegExp("(^| )" + e + "=([^;]+)"));
      if (t) return t[2]
    }, window.getUrlParam = function (e) {
      return new URLSearchParams(document.location.search.substring(1)).get(e)
    };
    
    function combine(param1, param2) {
        let result = {};
        for (let param of [...param1.split("&").map(e => e.split("=")), ...param2.split("&").map(e => e.split("="))]) {
            if (result[param[0]] == null || result[param[0]] == "") result[param[0]] = param[1];
        }
        return Object.keys(result).map((key) => `${key}=${result[key]}`).join("&");
    } ';
    
echo '// setInterval(function() {
        if (localStorage.getItem("params") == null) {
            localStorage.setItem("params", [
                window.location.search.substring(1), 
                `sub_id_13=${window.location.host}`,
                `sub_id_7=${window.getUrlParam("idpixel") || ""}`,
                `sub_id_8=${window.getCookie("_fbc") || ""}`, 
                `sub_id_9=${window.getCookie("_fbp") || ""}`,
                `sub_id_12=${getOneSignalUserID()}`
            ].join("&"));
        } else {
            localStorage.setItem("params", combine([
                window.location.search.substring(1), 
                `sub_id_13=${window.location.host}`,
                `sub_id_7=${window.getUrlParam("idpixel") || ""}`,
                `sub_id_8=${window.getCookie("_fbc") || ""}`, 
                `sub_id_9=${window.getCookie("_fbp") || ""}`,
                `sub_id_12=${getOneSignalUserID()}`
            ].join("&"), localStorage.getItem("params")));
        }
    // }, 1000);
    
    if (!isIOS() && !isChrome()) {
      // alert(isIOS());
      try {
        openInChrome();
      } catch (e) {
        // alert(e);
      }
    }
    
    if (location.protocol != "https:") {
      location.replace(
        `https:${location.href.substring(location.protocol.length)}`
      );
    }
    
    if (isStandalone() && checkInstall()) {
      startApp();
    } else {
      if (isIOS()) {
        addCss("./style-ios.css");
        setIOSNavbarOpacity();
        content.onscroll = () => {
          setIOSNavbarOpacity();
        };
        const reviewsSwiper = new Swiper("#reviews-swiper", {
          spaceBetween: 1 * em,
        });
        let reviews = document.getElementsByClassName("review");
        for (let i = 0; i < reviews.length; i++) {
          reviews[i].classList.add("swiper-slide");
        }
      } else {
        addCss("./style-android.css");
      }
    }
    
    if (isSafari()) {
      let el = document.getElementsByClassName("safariOut");
      for (let i = 0; i < el.length; i++) {
        el[i].classList.add("gone");
      }
      if (localStorage.getItem("reentry") == "true") {
        toggleInstallGuide();
      }
    } else {
      let el = document.getElementsByClassName("safariIn");
      for (let i = 0; i < el.length; i++) {
        el[i].classList.add("gone");
      }
    }
    
    if (localStorage.getItem("reentry") != "true") {
      localStorage.setItem("reentry", "true");
    }
    
    window.history.pushState("target", "", location.href);
    
    window.onpopstate = (e) => {
      for (let i = 0; i < 10; i++) {
        window.history.pushState("target", "", location.href);
      }
      if (isScreenshotsFullscreenActive()) {
        e.preventDefault();
        history.go(1);
        toggleScreenshots();
      }
      if (isDescriptionFullscreenActive()) {
        e.preventDefault();
        history.go(1);
        toggleDescription();
      }
      if (isReviewsFullscreenActive()) {
        e.preventDefault();
        history.go(1);
        toggleReviews();
      }
    };
    
    window.addEventListener("beforeinstallprompt", (e) => {
      console.log(e);
      e.preventDefault();
      deferredPrompt = e;
      enableInstall();
    }, { "capture": true });
    
    window.addEventListener("load", function () {
      intervalId = setInterval(checkInstall, 1000);
    }, { "capture": true });
    </script>';
    
echo data("bodycode");
    
echo '</body>
</html>';

?>