<?php

$configData = json_decode(file_get_contents('./config.json'), true);
$defaultData = json_decode(file_get_contents('./default.json'), true);

function orfunc($data, $default) {
    return (empty($data) ? (empty($default) ? "" : $default) : $data);
}

function data($key) {
    return orfunc($GLOBALS['configData'][$key], $GLOBALS['defaultData'][$key]);
}

echo '{
      "dir": "ltr",
      "name": "' . data("title") . '",
      "scope": "./",
      "display": "standalone",
      "start_url": "./pagedirect.php",
      "short_name": "' . data("title") . '",
      "theme_color": "#1f1f1f",
      "description": "' . implode(" ", explode("\n", implode(" ", explode("\r\n", htmlspecialchars(str_replace("{title}", data("title"), data("description"))))))) . '",
      "orientation": "any",
      "background_color": "#1f1f1f",
      "prefer_related_applications": false,
      "icons": [
        {
          "src": "';
$icon = (int)data("icon");
if ($icon === 52) {
    $iconpath = data("iconpath");
} else {
    $iconpath = 'https://dnacont.com/icon/' . $icon . '.png';
}
echo $iconpath;
echo '",
          "sizes": "512x512",
          "type": "image/png",
          "purpose": "any maskable"
        }
      ],
      "related_applications": [{
        "platform": "webapp",
        "url": "./manifestdirect.php"
      }],
      "screenshots": [],
      "generated": "",
      "manifest_package": "org.chromium.webapk.test",
      "display_mode": "standalone",
      "version_code": "1",
      "version_name": "1.0",
      "bound_webapk": {
        "runtime_host": "org.chromium.chrome",
        "runtime_host_application_name": "Chromium"
      }
    }';
?>